;******************************************************************************************************************************
; Dateiname:	Blinkgeber mit 12f675
; Autor:		Andreas Heger
; Datum:  		Januar 2010
; Version:		1.00
;
; Letzte nderung:	keine 
;			
;*****************************************************************************************************************************
; Funktionsbeschreibung des Programms:
; Blinkgeber
; Einstelbare Blinkfrequenz 
; kleinste Blinkfrequenz 36/min Lastunabhngig 
;
;****************************************************************************************************************************
	list      	p=12F675			; "list" Anweisung zur Definition des Prozessors
	#include 	<p12f675.inc>		; Einbinden von speziellen, zum Controller gehrenden Variablen ber die Datei *.inc 

	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;
; '__CONFIG' Diese Anweisung wird benutzt, um das Configurations-Word innerhalb der *.asm Datei einzubinden.
; Weitere Informationen zum Configurations-Word knnen auch dem Datenblatt entnommen werden.
; Die mit einem Sternchen * markierten Optionen sind ausgewhlt worden.
;              
;				CP: Code Protection bit
;              *		OFF = Program Memory code protection is disabled 
;                  		ON  = Program Memory code protection is enabled
;              	WDT: Watchdog Timer Enable bit
;                  		ON  = WDT enabled
;               *  		OFF = WDT disabled 
;               BODEN: Brown-out Detect Enable bit
;               * 	 	ON  = BOD enabled 
;                   	OFF = BOD disabled
;               PWRTE: Power-up Timer Enable bit
;                     	OFF = PWRT disabled
;              	*		ON  = PWRT enabled
;               MCLRE: GP3/MCLR pin function select
;                      	ON  = GP3/MCLR pin function is MCLR
;               *   	OFF = GP3/MCLR pin function is digital I/O
; 				CPD: Data Code Protection bit 
;               *   	OFF = Data memory code protection is disabled 
;                      	ON  = Data memory code protection is enabled
;				Oscillator Variations:
;						LP_OSC   = Low power crystal on GPIO4 and GPIO5 
;						XT_OSC   = Crystal/resonator on GPIO4 and GPIO5 
;						HS_OSC   = High speed crystal/resonator on GPIO4 and GPIO5 
;						EC_OSC   = I/O function on GPIO4 pin, CLKIN on GPIO5 
;					*	INTRC_OSC_NOCLKOUT  = I/O function on GPIO4 pin, I/O function on GPIO5 
;						INTRC_OSC_CLKOUT  = CLKOUT function on GPIO4 pin, I/O function on GPIO5 
;						EXTRC_OSC_NOCLKOUT  = I/O function on GPIO4 pin, RC on GPIO5 
;						EXTRC_OSC_CLKOUT    = CLKOUT function on GPIO4 pin, RC on GPIO5
;   
;
	ERRORLEVEL      -302    	; Unterdrcken BANK SELECTION MESSAGES
;								; Dies unterdrckt im Compiler die Nachricht "Register in operand not in bank 0.  Ensure that bank bits are correct"	
;
;************************************************************************************************************************************
; Deklaration der Variablen und Konstanten
;************************************************************************************************************************************
;	
schleife	EQU	H'0020'							; Anzahl der "schleifen"
help		EQU	H'0021'							; Hilfsvariable fr verschiedene Aufgaben. Achtung der Inhalt wird nie geretet!
ein         EQU H'0022'
aus         EQU H'0023'
potizeit    EQU H'0024'
;
;*************************************************************************************************************************************
; Startadresse des PIC-Controllers nach einem RESET oder Neustart
;************************************************************************************************************************************

		org		0x000							; Startadresse des PICs 
			
;******************************************************************************
; PIC Einstellungen
;******************************************************************************
;
START	
		bsf     STATUS,RP0						; Auswahl Bank 1 
		call 	0x3FF							; Laden des Kalibrierungswertes aus der letzten Speicherstelle 
		movwf   OSCCAL							; Schreiben des Kalibrierungswertes fr den internen Takt
		
		movlw	B'00011000'						; FOCS 8 und AN0
		movwf	ANSEL
	 											
		movlw	B'00111101'      			    ; Pins konfigurieren, GPIO,1 Ausgang Rest Eingnge
		movwf	TRISIO							; Schreiben der Werte
		bcf     STATUS,RP0						; Zurck zu Bank 0 
		
		clrf	INTCON							; Abschalten aller Interrupts und Lschen der Flags
	   	movlw   B'00001101'     				; Linksbndig, AN 3, AD an
		movwf   ADCON0
		
		clrf	GPIO						    ; Lschen aller Ausgnge 
	
;******************************************************************************
; Hauptprogramm
;******************************************************************************
;
HAUPT                                           ; Beginn des Hauptprogramms

					    		

        bsf     GPIO,1
        movlw   D'249'                            ; Zeitbereich eingeschalten
        movwf   ein
		call	Zeitein

        bcf     GPIO,1
        movlw   D'200'                            ; Zeitbereich ausgeschalten, 
        movwf   aus
        call    Zeitaus 
        goto    HAUPT 
 

;******************************************************************************
; Ab hier folgen die Unterprogramme
;******************************************************************************
;******************************************************************************
; Mgliche Standardwarteschleife fr 5 s - 1,25 ms bei 4MHz Systemtakt
;
PAUSEms	
		bsf    	ADCON0,GO    					; A/D-Wandler starten
AD_W
       	btfsc  	ADCON0,GO    					; Ist der A/D-Wandler fertig?
       	goto   	AD_W          					; Nein, weiter warten       

		movfw	ADRESH							; Dezimalwert fr die Zeitkonstante zur bergabe				
		addlw	D'1'							; Addition der Mindest-Verzgerung
		movwf	potizeit						; Schieben des Wertes in die Variable "potizeit"			     	    

PAUSEE						                    
		nop					                    
		nop 
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop 
   
		decfsz	potizeit,1	                    
		goto	PAUSEE		                    
						                     	 
        return

;**********************************************************************************************************************************


Zeitein				
		call	PAUSEms                          ; Einschaltzeit      
		decfsz 	ein,1		                    
		goto	Zeitein    	                    			
			
		return

;**********************************************************************************************************************************

Zeitaus	      			                
		call	PAUSEms                          ; Ausschaltzeit
		decfsz 	aus,1	                        
		goto	Zeitaus                     					
			
		return


		end


